@extends('layouts.app')
@section('content')
<div class="content-wrapper">
	<div class="content pt-3">
		<div class="container-fluid">
			<div class="row">
				<div class="col-12">
					<div class="card border-0 shadow-custom">
						<div class="card-header border-grey">
							<h3 class="card-title">
								{{ __('plan.list_title') }}
							</h3>
						</div>
						<div class="card-body px-3 pt-3 pb-0">
							<div class="row">
								<div class="col-md-12 d-flex justify-content-end ">
									<form method="post" action="{{ route('plan.index') }}">
										{{ csrf_field() }}
										<div class="input-group mb-3">
											<input type="text" name="search" class="form-control"
												placeholder="{{ __('plan.search') }}" required>
											<div class="input-group-append">
												<button class="btn btn-primary" type="submit">
													<i class="fas fa-search"></i>
												</button>
											</div>
										</div>
									</form>
								</div>
								<div class="col-12">
									<div class="table-responsive">
										<table class="table custom-table-bordered table-hover">
											<thead>
												<tr>
													<th>{{ __('plan.th_name') }}</th>
													<th>{{ __('plan.th_description') }}</th>
													<th>{{ __('plan.th_duration') }}</th>
													<th>{{ __('plan.th_amount') }}</th>
													<th class="fixed-width-td">{{ __('plan.th_action') }}</th>
												</tr>
											</thead>
											<tbody>
												@foreach($plans as $plan)
												<tr>
													<td class="align-middle nowrap">{{ $plan->name }}</td>
													<td class="align-middle nowrap">{{ $plan->description }}</td>
													<td class="align-middle nowrap">{{ pluralize($plan->duration) }}
													</td>
													<td class="align-middle nowrap">{{ format_amount($plan->amount) }}
													</td>
													<td>
														<div class="d-flex">
															<a href="{{ route('plan.edit', $plan->id) }}" type="button"
																class="btn btn-warning mr-2">
																<i class="fa fa-edit"></i>
															</a>
															<form class="d-inline js-confirm-delete" method="POST"
																action="{{ route('plan.destroy', $plan->id) }}">
																{{ csrf_field() }}
																@method('DELETE')
																<button class="btn btn-danger"><i
																		class="fa fa-trash"></i></button>
															</form>
														</div>
													</td>
												</tr>
												@endforeach
												@if(count($plans) == 0)
												<tr>
													<td colspan="9">
														<p class="text-center mb-0">{{ __('plan.no_record_found') }}</p>
													</td>
												</tr>
												@endif
											</tbody>
										</table>
									</div>
								</div>
								<div class="col-12">
									<div class="d-flex justify-content-end">
										@if($paginate)
										{{ $plans->links() }}
										@endif
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>
@endsection